<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <!-- Turnout Points Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!--Title displayed in browser Title Bar-->
                <title lang="en">Výpis bodů výhybky</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!--Report Title-->
                                <h2 lang="en">Výpis bodů výhybky</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            
                            <!--Project Data-->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                                            <td align="left" style="font-size: 80%"><xsl:value-of select="../@inputGridScaleFactor" /></td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <xsl:for-each select="Turnout">
                                    <table class="margin" cellpadding="1" width="90%">
                                        <tbody>
                                            <tr>
                                                <td align="left" colspan="6" lang="en"><strong>Výhybka:&#xa0; </strong>
                                                    <xsl:value-of select="@name"/>
                                                    <xsl:text>&#xa0;</xsl:text>
                                                    <xsl:value-of select="@description"/>
                                                    (<xsl:value-of select="@style"/>)
                                                </td>
                                            </tr>
                                            <xsl:apply-templates/>
                                        </tbody>
                                    </table>
                                    <hr/>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    
    <!--Points-->
    <xsl:template match="TurnoutPoint">
        <xsl:if test="preceding-sibling::*[1][name() != 'TurnoutPoint']">
            <tr>
                <th align="left" lang="en" valign="bottom">Název bodu</th>
                <th align="left" lang="en" valign="bottom">Hlavní<br/>trasa</th>
                <th align="right" lang="en" valign="bottom">Staničení</th>
                <th align="right" lang="en" valign="bottom">Odstup</th>
                <th align="right" lang="en" valign="bottom">Y</th>
                <th align="right" lang="en" valign="bottom">X</th>
                <th align="right" lang="en" valign="bottom">Tečna</th>
                <th align="right" lang="en" valign="bottom">Poloměr</th>
            </tr>
        </xsl:if>
        <tr>
            <td align="left"><xsl:value-of select="GeometryPoint/@name"/></td>
            <td align="left">
                <xsl:value-of select="@mainlineAlignment"/>
            </td>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:stationFormat(number(GeometryPoint/Station/@externalStation), string(GeometryPoint/Station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(GeometryPoint/@offset))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
            </td>
             <td align="right">
                <xsl:value-of select="cif:directionFormat(number(GeometryPoint/@azimuth))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@radius))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <xsl:text>Copyright 2018 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
